<div class="modal fade" id="platoModal" tabindex="-1" role="dialog" aria-labelledby="platoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document"><!-- CAMBIADO A modal-lg -->
        <div class="modal-content">
            <div class="modal-header bg-secondary text-white">
                <h5 class="modal-title" id="platoModalLabel">Nuevo Plato</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="platoForm" enctype="multipart/form-data">
                <div class="modal-body">
                    <input type="hidden" id="plato_id" name="plato_id">

                    <!-- === Carta y Subcarta === -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="carta_id">Carta *</label>
                                <select class="form-control" id="carta_id" name="carta_id" required>
                                    <option value="">Seleccione una carta</option>
                                    <?php $__currentLoopData = $cartas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $carta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($carta->id); ?>">
                                            <?php echo e($carta->translate(app()->getLocale())->nombre ?? $carta->id); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="sub_carta_id">Subcarta</label>
                                <select class="form-control" id="sub_carta_id" name="sub_carta_id">
                                    <option value="">Seleccione una subcarta</option>
                                    <?php $__currentLoopData = $subcartas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcarta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($subcarta->id); ?>">
                                            <?php echo e($subcarta->translate(app()->getLocale())->nombre ?? $subcarta->id); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- === Precio, Orden, Activo === -->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="precio">Precio *</label>
                                <input type="number" step="0.01" class="form-control" id="precio" name="precio"
                                    required min="0">
                            </div>
                        </div>
                    </div>



                    <!-- === Alérgenos === -->
                    <div class="form-group">
                        <label>Alérgenos</label>
                        <div class="row">
                            <?php $__currentLoopData = $alergenos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alergeno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input"
                                            id="alergeno_<?php echo e($alergeno->id); ?>" name="alergenos[]"
                                            value="<?php echo e($alergeno->id); ?>">
                                        <label class="custom-control-label" for="alergeno_<?php echo e($alergeno->id); ?>">
                                            <?php echo e($alergeno->translate(app()->getLocale())->nombre ?? $alergeno->id); ?>

                                        </label>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <!-- === Traducciones === -->
                    <hr>

                    <!-- Nombre -->
                    <div class="form-group">
                        <label>Nombre *</label>
                        <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="input-group mb-2">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <img src="<?php echo e(asset($lang->image ?? 'images/empty.png')); ?>"
                                            alt="<?php echo e($lang->name); ?>" width="20" height="20">
                                    </span>
                                </div>
                                <input type="text" class="form-control" id="nombre_<?php echo e($lang->code); ?>"
                                    name="nombre[<?php echo e($lang->code); ?>]" placeholder="Nombre en <?php echo e($lang->name); ?>"
                                    required>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <!-- Descripción -->
                    <div class="form-group">
                        <label>Descripción</label>
                        <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="input-group mb-2">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <img src="<?php echo e(asset($lang->image ?? 'images/empty.png')); ?>"
                                            alt="<?php echo e($lang->name); ?>" width="20" height="20">
                                    </span>
                                </div>
                                <textarea class="form-control" id="descripcion_<?php echo e($lang->code); ?>" name="descripcion[<?php echo e($lang->code); ?>]"
                                    placeholder="Descripción en <?php echo e($lang->name); ?>" rows="2"></textarea>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="activo" class="d-block">Estado</label>
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="activo" name="activo"
                                        value="1" checked>
                                    <label class="custom-control-label" for="activo">Activo</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- === Imagen === -->
                    <div class="form-group">
                        <label for="imagen">Imagen del Plato</label>
                        <input type="file" class="form-control-file" id="imagen" name="imagen"
                            accept="image/*">
                        <small class="form-text text-muted">Formatos: JPEG, PNG, GIF, WEBP. Máx: 2MB</small>
                        <div id="imagen-preview" class="mt-2"></div>
                        <div id="eliminar-imagen-container" class="mt-2" style="display: none;">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="eliminar_imagen"
                                    name="eliminar_imagen" value="1">
                                <label class="form-check-label" for="eliminar_imagen">Eliminar imagen actual</label>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- === Footer === -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>




<?php /**PATH C:\Users\Dante\AppData\Local\server\www\manu\resources\views/platos/modal.blade.php ENDPATH**/ ?>