<?php $__env->startSection('title', 'Ordenar Alergenos' . ' | ' . config('app.name')); ?>

<?php $__env->startSection('content_header'); ?>
    <div class="w-100">
        <?php
            $breadcrumbs = [
                ['name' => 'Inicio', 'route' => 'dashboard', 'icon' => 'fa-home'],
                ['name' => 'Alergenos', 'route' => 'alergenos.index'],
                ['name' => 'Ordenar Alergenos'],
            ];
        ?>

        <nav aria-label="breadcrumb">
            <ol class="breadcrumb bg-light p-2 rounded shadow-sm">
                <?php $__currentLoopData = $breadcrumbs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $breadcrumb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(isset($breadcrumb['route'])): ?>
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route($breadcrumb['route'])); ?>">
                                <?php if(isset($breadcrumb['icon'])): ?>
                                    <i class="fas <?php echo e($breadcrumb['icon']); ?> mr-1"></i>
                                <?php endif; ?>
                                <?php echo e($breadcrumb['name']); ?>

                            </a>
                        </li>
                    <?php else: ?>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e($breadcrumb['name']); ?></li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ol>
        </nav>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="m-0">
        <div class="card shadow-sm">
            <div class="card-header">
                <div class="row align-items-center">
                    <!-- Título -->
                    <div class="col-12 col-md-6">
                        <h5 class="mb-md-0">Ordenar Alergenos</h5>
                    </div>

                    <!-- Botón -->

                </div>
            </div>

            <div class="card-body p-2">

                <p class="text-muted">Arrastra y suelta para cambiar el orden de los alergenos.</p>

                <ul id="sortable" class="list-group sortable">
                    <?php $__currentLoopData = $alergenos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alergeno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="list-group-item d-flex align-items-center" data-id="<?php echo e($alergeno->id); ?>">
                            <i class="fa-solid fa-arrows-alt fa-lg me-3 text-secondary drag-handle"></i>
                            <?php echo e($alergeno->translate(app()->getLocale())->nombre); ?>

                            <?php if(!$alergeno->activo): ?>
                                <span class="badge bg-danger ms-auto"><i class="fa-solid fa-ban"></i> Inactivo</span>
                            <?php endif; ?>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>

                <div class="mt-3">
                    <button id="guardarOrden" class="btn btn-success">
                        <i class="fa-solid fa-floppy-disk"></i> Guardar Orden
                    </button>
                </div>
            </div>
        </div>
    </div>





<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <style>
        ul.sortable {
            list-style: none;
            padding-left: 0;
            margin: 0;
        }

        .sortable li {
            cursor: grab;
            /* cuando está quieto */
        }

        .sortable li:active {
            cursor: grabbing;
            /* cuando lo arrastras */
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
    <script>
        $(function() {
            $("#sortable").sortable({
                placeholder: "ui-state-highlight",
                handle: ".drag-handle",
                cursor: "grabbing"
            }).disableSelection();

            $('#guardarOrden').click(function() {
                let orden = [];
                $('#sortable li').each(function() {
                    orden.push($(this).data('id'));
                });

                $.ajax({
                    url: "<?php echo e(route('alergenos.ordenar.guardar')); ?>",
                    method: "POST",
                    data: {
                        orden: orden,
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success: function(resp) {
                        if (resp.success) {
                            Toast.fire({
                                icon: 'success',
                                title: 'Orden guardado correctamente'
                            });
                        }
                    },
                    error: function() {
                        Toast.fire({
                            icon: 'error',
                            title: 'Error al guardar el orden'
                        });
                    }
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\PAN82\htdocs\manu\resources\views/alergenos/ordenar.blade.php ENDPATH**/ ?>