@extends('adminlte::page')

@section('title', 'Dashboard')

@section('content_header')
    <h1>Editar Perfil</h1>
@stop

@section('content')

<div class="card">
    <div class="card-body">
        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <form action="{{ route('profile.update') }}" method="POST">
            @csrf

            <div class="form-group">
                <label for="name">Nombre</label>
                <input value="{{ old('name', $user->name) }}" 
                       type="text" 
                       name="name" 
                       class="form-control @error('name') is-invalid @enderror">
                @error('name')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>

            <div class="form-group mt-3">
                <label for="email">Correo electrónico</label>
                <input value="{{ old('email', $user->email) }}" 
                       type="email" 
                       name="email" 
                       class="form-control @error('email') is-invalid @enderror">
                @error('email')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>

            <button type="submit" class="btn btn-primary mt-3">
                <i class="fas fa-save"></i> Guardar
            </button>
        </form>
    </div>
</div>


@stop

@section('css')
    {{-- Add here extra stylesheets --}}
    {{-- <link rel="stylesheet" href="/css/admin_custom.css"> --}}
@stop

@push('js')
 
@endpush
