@extends('adminlte::page')

@section('title', 'Dashboard')

@section('content_header')
    <h1>Change Password</h1>
@stop

@section('content')

<div class="card">
    <div class="card-body">

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <form action="{{ route('profile.password.update') }}" method="POST">
            @csrf

            <div class="form-group">
                <label for="current_password">Contraseña actual</label>
                <input type="password" 
                       name="current_password" 
                       class="form-control @error('current_password') is-invalid @enderror">
                @error('current_password')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>

            <div class="form-group mt-3">
                <label for="password">Nueva contraseña</label>
                <input type="password" 
                       name="password" 
                       class="form-control @error('password') is-invalid @enderror">
                @error('password')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>

            <div class="form-group mt-3">
                <label for="password_confirmation">Confirmar nueva contraseña</label>
                <input type="password" 
                       name="password_confirmation" 
                       class="form-control">
            </div>

            <button type="submit" class="btn btn-primary mt-3">
                <i class="fas fa-save"></i> Guardar
            </button>
        </form>
    </div>
</div>

@stop

@section('css')
    {{-- Add here extra stylesheets --}}
    {{-- <link rel="stylesheet" href="/css/admin_custom.css"> --}}
@stop

@push('js')
 
@endpush
