<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bebida_langs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bebida_id')->constrained('bebidas')->cascadeOnDelete();
            $table->string('locale')->index();
            $table->string('nombre');
            $table->text('descripcion')->nullable();
            $table->string('slug')->nullable();
            $table->unique(['bebida_id', 'locale']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bebida_langs');
    }
};
