<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePlatosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('platos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('carta_id')->constrained('cartas')->cascadeOnDelete();
            $table->foreignId('sub_carta_id')->nullable()->constrained('sub_cartas')->cascadeOnDelete();
            $table->string('imagen')->nullable();
            $table->decimal('precio', 10, 2)->default(0);
            $table->integer('orden')->default(0);
            $table->boolean('activo')->default(true);
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('plato_langs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('plato_id')->constrained('platos')->cascadeOnDelete();
            $table->string('locale')->index();
            $table->string('nombre');
            $table->text('descripcion')->nullable();
            $table->string('slug')->nullable();
            $table->unique(['plato_id', 'locale']);
        });

        // Tabla pivote para alergénicos
        Schema::create('plato_alergeno', function (Blueprint $table) {
            $table->id();
            $table->foreignId('plato_id')->constrained('platos')->cascadeOnDelete();
            $table->foreignId('alergeno_id')->constrained('alergenos')->cascadeOnDelete();
            $table->timestamps();
            $table->unique(['plato_id', 'alergeno_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('plato_alergeno');
        Schema::dropIfExists('plato_langs');
        Schema::dropIfExists('platos');
    }
}
