<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('carta_langs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('carta_id')->constrained('cartas')->cascadeOnDelete();

            $table->string('locale', 5)->index();  // ej. "es", "en", "fr"
            $table->string('nombre');              // nombre visible
            $table->string('slug')->unique();      // URL amigable por idioma
            $table->text('descripcion')->nullable();

            $table->timestamps();

            $table->unique(['carta_id', 'locale']); // un idioma por carta
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('carta_lang');
    }
};
