<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ProfileController extends Controller
{
    public function edit()
    {
        $user = Auth::user(); // usuario en sesión
        return view('admin.profile.edit', compact('user'));
    }

    public function update(Request $request)
    {
        /**
         * @var \App\Models\User $user
         */
        $user = Auth::user();

        $data = $request->validate([
            'name'  => 'required|string|max:255',
            'email' => 'required|email|max:255|unique:users,email,' . $user->id,
        ]);

        $user->update($data);

        return redirect()->route('profile.edit')->with('success', 'Perfil actualizado correctamente.');
    }
}
