<?php $__env->startSection('title', 'Ordenar Cartas' . ' | ' . config('app.name')); ?>

<?php $__env->startSection('content_header'); ?>
    <div class="w-100">
        <?php
            $breadcrumbs = [
                ['name' => 'Inicio', 'route' => 'dashboard', 'icon' => 'fa-home'],
                ['name' => 'Cartas', 'route' => 'cartas.index'],
                ['name' => 'Ordenar Cartas'],
            ];
        ?>

        <nav aria-label="breadcrumb">
            <ol class="breadcrumb bg-light p-2 rounded shadow-sm">
                <?php $__currentLoopData = $breadcrumbs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $breadcrumb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(isset($breadcrumb['route'])): ?>
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route($breadcrumb['route'])); ?>">
                                <?php if(isset($breadcrumb['icon'])): ?>
                                    <i class="fas <?php echo e($breadcrumb['icon']); ?> mr-1"></i>
                                <?php endif; ?>
                                <?php echo e($breadcrumb['name']); ?>

                            </a>
                        </li>
                    <?php else: ?>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e($breadcrumb['name']); ?></li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ol>
        </nav>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="m-0">
        <div class="card shadow-sm">
            <div class="card-header">
                <div class="row align-items-center">
                    <!-- Título -->
                    <div class="col-12 col-md-6">
                        <h5 class="mb-md-0">Ordenar Cartas</h5>
                    </div>

                    <!-- Botón -->

                </div>
            </div>

            <div class="card-body p-2">

                <p class="text-muted">Arrastra y suelta para cambiar el orden de las cartas.</p>

                <ul id="sortable" class="list-group">
                    <?php $__currentLoopData = $cartas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $carta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="list-group-item d-flex align-items-center" data-id="<?php echo e($carta->id); ?>">
                            <i class="fa-solid fa-arrows-alt fa-lg me-3 text-secondary"></i>
                            <span><?php echo e($carta->translate(app()->getLocale())->nombre); ?></span>
                            <?php if(!$carta->activo): ?>
                                <span class="badge bg-danger ms-auto">Inactivo</span>
                            <?php endif; ?>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>

                <div class="mt-3">
                    <button id="guardarOrden" class="btn btn-primary">
                        <i class="fa-solid fa-floppy-disk"></i> Guardar Orden
                    </button>
                </div>
            </div>
        </div>
    </div>





<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>

    <script>
        $(function() {
            $("#sortable").sortable();
            $("#sortable").disableSelection();

            $('#guardarOrden').click(function() {
                let orden = [];
                $('#sortable li').each(function() {
                    orden.push($(this).data('id'));
                });

                $.ajax({
                    url: "<?php echo e(route('cartas.ordenar.guardar')); ?>",
                    method: "POST",
                    data: {
                        orden: orden,
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success: function(resp) {
                        if (resp.success) {
                            Toast.fire({
                                icon: 'success',
                                title: 'Orden guardado correctamente'
                            });
                        }
                    },
                    error: function() {
                        Toast.fire({
                            icon: 'error',
                            title: 'Hubo un problema al guardar el orden'
                        });
                    }
                });
            });

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Dante\AppData\Local\server\www\manu\resources\views/cartas/ordenar.blade.php ENDPATH**/ ?>