<?php $__env->startSection('title', 'Ordenar Platos' . ' | ' . config('app.name')); ?>

<?php $__env->startSection('content_header'); ?>
    <div class="w-100">
        <?php
            $breadcrumbs = [
                ['name' => 'Inicio', 'route' => 'dashboard', 'icon' => 'fa-home'],
                ['name' => 'Platos', 'route' => 'platos.index'],
                ['name' => 'Ordenar Platos'],
            ];
        ?>

        <nav aria-label="breadcrumb">
            <ol class="breadcrumb bg-light p-2 rounded shadow-sm">
                <?php $__currentLoopData = $breadcrumbs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $breadcrumb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(isset($breadcrumb['route'])): ?>
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route($breadcrumb['route'])); ?>">
                                <?php if(isset($breadcrumb['icon'])): ?>
                                    <i class="fas <?php echo e($breadcrumb['icon']); ?> mr-1"></i>
                                <?php endif; ?>
                                <?php echo e($breadcrumb['name']); ?>

                            </a>
                        </li>
                    <?php else: ?>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e($breadcrumb['name']); ?></li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ol>
        </nav>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="m-0">
        <div class="card shadow-sm">
            <div class="card-header">
                <div class="row align-items-center">
                    <!-- Título -->
                    <div class="col-12 col-md-6">
                        <h5 class="mb-md-0">Ordenar Platos</h5>
                    </div>

                    <!-- Botón -->

                </div>
            </div>

            <div class="card-body p-2">

                <p class="text-muted">Arrastra y suelta para cambiar el orden de los Platos.</p>

                <?php $__currentLoopData = $cartas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $carta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card mb-4 shadow-sm">
                        <div class="card-header bg-primary text-white">
                            <i class="fa-solid fa-layer-group"></i>
                            <?php echo e($carta->translate(app()->getLocale())->nombre); ?>

                        </div>

                        
                        <?php if($carta->platos->count()): ?>
                            <ul class="list-group list-group-flush sortable" data-carta-id="<?php echo e($carta->id); ?>"
                                data-sub-id="null">
                                <?php $__currentLoopData = $carta->platos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plato): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="list-group-item d-flex align-items-center" data-id="<?php echo e($plato->id); ?>">
                                        <i class="fa-solid fa-arrows-alt fa-lg me-3 text-secondary drag-handle"></i>
                                        <?php echo e($plato->translate(app()->getLocale())->nombre); ?>

                                        <?php if(!$plato->activo): ?>
                                            <span class="badge bg-danger ms-auto"><i class="fa-solid fa-ban"></i>
                                                Inactivo</span>
                                        <?php endif; ?>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        <?php endif; ?>

                        
                        <?php $__currentLoopData = $carta->subCartas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="card-body border-top">
                                <h6 class="fw-bold">
                                    <i class="fa-solid fa-diagram-project"></i>
                                    <?php echo e($sub->translate(app()->getLocale())->nombre); ?>

                                </h6>
                                <ul class="list-group list-group-flush sortable" data-carta-id="<?php echo e($carta->id); ?>"
                                    data-sub-id="<?php echo e($sub->id); ?>">
                                    <?php $__currentLoopData = $sub->platos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plato): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="list-group-item d-flex align-items-center"
                                            data-id="<?php echo e($plato->id); ?>">
                                            <i class="fa-solid fa-arrows-alt fa-lg me-3 text-secondary drag-handle"></i>
                                            <?php echo e($plato->translate(app()->getLocale())->nombre); ?>

                                            <?php if(!$plato->activo): ?>
                                                <span class="badge bg-danger ms-auto"><i class="fa-solid fa-ban"></i>
                                                    Inactivo</span>
                                            <?php endif; ?>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <div class="mt-3">
                    <button id="guardarOrden" class="btn btn-success">
                        <i class="fa-solid fa-floppy-disk"></i> Guardar Orden
                    </button>
                </div>

            </div>
        </div>
    </div>





<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <style>
        ul.sortable {
            list-style: none;
            padding-left: 0;
            margin: 0;
        }

        .sortable li {
            cursor: grab;
        }

        .sortable li:active {
            cursor: grabbing;
        }

        .ui-state-highlight {
            height: 2.5rem;
            background: #e9ecef;
            border: 2px dashed #adb5bd;
            border-radius: 0.5rem;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>

    <script>
        $(function() {
            $(".sortable").sortable({
                placeholder: "ui-state-highlight",
                handle: ".drag-handle",
                cursor: "grabbing"
            }).disableSelection();

            $('#guardarOrden').click(function() {
                let orden = {};

                $(".sortable").each(function() {
                    let cartaId = $(this).data('carta-id');
                    let subId = $(this).data('sub-id');
                    let lista = [];

                    $(this).find('li').each(function() {
                        lista.push($(this).data('id'));
                    });

                    if (!orden[cartaId]) orden[cartaId] = {};
                    orden[cartaId][subId] = lista;
                });

                $.ajax({
                    url: "<?php echo e(route('platos.ordenar.guardar')); ?>",
                    method: "POST",
                    data: {
                        orden: orden,
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success: function(resp) {
                        if (resp.success) {
                            Toast.fire({
                                icon: 'success',
                                title: 'Orden guardado correctamente'
                            });
                        }
                    },
                    error: function() {
                        Toast.fire({
                            icon: 'error',
                            title: 'Error al guardar el orden'
                        });
                    }
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\PAN82\htdocs\manu\resources\views/platos/ordenar.blade.php ENDPATH**/ ?>