<?php $__env->startSection('title', 'Usuarios' . ' | ' . config('app.name')); ?>

<?php $__env->startSection('content_header'); ?>
    <div class="w-100">
        <?php
            $breadcrumbs = [
                ['name' => 'Inicio', 'route' => 'dashboard', 'icon' => 'fa-home'],
                ['name' => 'Cartas', 'route' => 'cartas.index'],
                ['name' => 'Lista de Cartas'],
            ];
        ?>

        <nav aria-label="breadcrumb">
            <ol class="breadcrumb bg-light p-2 rounded shadow-sm">
                <?php $__currentLoopData = $breadcrumbs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $breadcrumb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(isset($breadcrumb['route'])): ?>
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route($breadcrumb['route'])); ?>">
                                <?php if(isset($breadcrumb['icon'])): ?>
                                    <i class="fas <?php echo e($breadcrumb['icon']); ?> mr-1"></i>
                                <?php endif; ?>
                                <?php echo e($breadcrumb['name']); ?>

                            </a>
                        </li>
                    <?php else: ?>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e($breadcrumb['name']); ?></li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ol>
        </nav>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="m-0">
        <div class="card shadow-sm">
            <div class="card-header">
                <div class="row align-items-center">
                    <!-- Título -->
                    <div class="col-12 col-md-6">
                        <h5 class="mb-md-0">Gestión de Cartas</h5>
                    </div>

                    <!-- Botón -->
                    <div class="col-12 col-md-6 text-md-right">
                        <button class="btn btn-success btn-sm" id="createNewCarta">
                            <i class="fas fa-plus"></i> Nueva Carta
                        </button>
                    </div>
                </div>
            </div>

            <div class="card-body p-2">
                <table class="table table-bordered table-hover" id="cartas-table" style="width: 100%;">
                    <thead class="thead-light">
                        <tr>
                            <th style="width: 5%"></th>
                            <th style="width: 5%">ID</th>
                            <th style="width: 45%">Nombre (ES)</th>
                            <th style="width: 15%">Orden</th>
                            <th style="width: 15%">Activo</th>
                            <th style="width: 10%">Acciones</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>


    <!-- Modal -->
    <!-- Modal -->
    <div class="modal fade" id="cartaModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form id="cartaForm">
                <?php echo csrf_field(); ?>
                <div class="modal-content">
                    <div class="modal-header bg-secondary">
                        <h5 class="modal-title">Carta</h5>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="id" id="id">

                        <?php
                            $langs = \App\Models\Lang::whereNull('deleted_at')->get(); // solo idiomas activos
                        ?>

                        <!-- Nombre -->
                        <div class="form-group">
                            <label>Nombre</label>
                            <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="input-group mb-2">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <img src="<?php echo e(asset($lang->image ?? 'images/empty.png')); ?>"
                                                alt="<?php echo e($lang->name); ?>" width="20" height="20" class="me-1">
                                        </span>

                                    </div>
                                    <input type="text" name="nombre[<?php echo e($lang->code); ?>]" class="form-control"
                                        placeholder="Nombre en <?php echo e($lang->name); ?>" required>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <!-- Descripción -->
                        <div class="form-group">
                            <label>Descripción</label>
                            <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="input-group mb-2">
                                    <span class="input-group-text">
                                        <img src="<?php echo e(asset($lang->image ?? 'images/empty.png')); ?>" alt="<?php echo e($lang->name); ?>"
                                            width="20" height="20" class="me-1 rounded">
                                    </span>
                                    <input type="text" name="descripcion[<?php echo e($lang->code); ?>]" class="form-control"
                                        placeholder="Descripción en <?php echo e($lang->name); ?>">
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>


                        <div class="form-group">
                            <label>Orden</label>
                            <input type="number" name="orden" id="orden" class="form-control">
                        </div>

                        <div class="form-group">
                            <label>Activo</label>
                            <input type="checkbox" name="activo" id="activo" value="1" checked>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Guardar</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    </div>
                </div>
            </form>
        </div>
    </div>




<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        $(function() {
            var table = $('#cartas-table').DataTable({
                responsive: {
                    details: {
                        type: 'column', // el signo + en la primera columna
                        target: 0 // en qué columna colocar el signo +
                    }
                },
                columnDefs: [{
                    className: 'dtr-control', // clase obligatoria para el botón de expandir
                    orderable: false,
                    targets: 0
                }],
                processing: true,
                serverSide: true,
                ajax: "<?php echo e(route('cartas.data')); ?>",
                columns: [{
                        data: null,
                        defaultContent: ''
                    },{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'nombre',
                        name: 'nombre'
                    },
                    {
                        data: 'orden',
                        name: 'orden'
                    },
                    {
                        data: 'activo',
                        name: 'activo',
                        render: function(d) {
                            return d ? 'Sí' : 'No';
                        }
                    },
                    {
                        data: 'acciones',
                        name: 'acciones',
                        orderable: false,
                        searchable: false
                    }
                ],
                 order: [
                    [1, 'desc']
                ], // <-- orden descendente por la columna "orden"
            });

            $('#createNewCarta').click(function() {
                $('#cartaForm').trigger("reset");
                $('#id').val('');
                $('#cartaModal').modal('show');
            });

            $('body').on('click', '.edit', function() {
                var id = $(this).data('id');

                // Generar la ruta con Blade y reemplazar el ID
                var url = "<?php echo e(route('cartas.edit', ':id')); ?>";
                url = url.replace(':id', id);

                $.get(url, function(data) {
                    $('#id').val(data.id);
                    $('#orden').val(data.orden);
                    $('#activo').prop('checked', data.activo);

                    // Español
                    $('#nombre_es').val(data.nombre['es-ES'] ?? '');
                    $('#descripcion_es').val(data.descripcion['es-ES'] ?? '');

                    // Inglés
                    $('#nombre_en').val(data.nombre['en'] ?? '');
                    $('#descripcion_en').val(data.descripcion['en'] ?? '');

                    $('#cartaModal').modal('show');
                });
            });



            $('#cartaForm').submit(function(e) {
                e.preventDefault();

                let form = $(this);

                $.ajax({
                    data: form.serialize(),
                    url: "<?php echo e(route('cartas.store')); ?>",
                    type: "POST",
                    success: function(response) {
                        $('#cartaModal').modal('hide');
                        table.ajax.reload();

                      

                        Toast.fire({
                            icon: 'success',
                            title: 'Carta guardada correctamente'
                        });
                    },
                    error: function(xhr) {

                        // mensaje por defecto
                        let message = "Ocurrió un error al guardar la carta.";

                        // si Laravel devuelve errores de validación
                        if (xhr.responseJSON && xhr.responseJSON.errors) {
                            let errors = xhr.responseJSON.errors;
                            message = Object.values(errors).join('<br>');
                        }

                        Toast.fire({
                            icon: 'error',
                            title: message
                        });
                    }
                });
            });


            $('body').on('click', '.delete', function() {
                var id = $(this).data('id');

                Swal.fire({
                    title: '¿Estás seguro?',
                    text: "¡Esta acción eliminará la carta!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Sí, eliminar',
                    cancelButtonText: 'Cancelar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            type: "DELETE",
                            url: "<?php echo e(url('admin/cartas')); ?>/" + id,
                            data: {
                                _token: '<?php echo e(csrf_token()); ?>'
                            },
                            success: function(response) {
                                table.ajax.reload();

                                Toast.fire({
                                    icon: 'success',
                                    title: 'Carta eliminada correctamente'
                                });
                            },
                            error: function(xhr) {
                               

                                Toast.fire({
                                    icon: 'error',
                                    title: 'No se pudo eliminar la carta'
                                });
                            }
                        });
                    }
                });
            });

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Dante\AppData\Local\server\www\manu\resources\views/cartas/index.blade.php ENDPATH**/ ?>