<?php

use App\Http\Controllers\AlergenoController;
use App\Http\Controllers\BebidaController;
use App\Http\Controllers\CartaController;
use App\Http\Controllers\GalleryPhotoController;
use App\Http\Controllers\GalleryController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PlatoController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ProfilePasswordController;
use App\Http\Controllers\SubCartaController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

/* Route::get('/', function () {
    return view('welcome');
}); */

Route::get('/', [HomeController::class, 'index'])->name('home');

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::prefix('admin/users')->group(function () {
        Route::get('/', [UserController::class, 'index'])->name('users.index');
        Route::get('/data', [UserController::class, 'data'])->name('users.data');
        Route::post('/store', [UserController::class, 'store'])->name('users.store');
        Route::get('/edit/{id}', [UserController::class, 'edit'])->name('users.edit');
        Route::delete('/delete/{id}', [UserController::class, 'destroy'])->name('users.destroy');
    });


    Route::prefix('admin')->group(function () {
        Route::get('profile', [ProfileController::class, 'edit'])->name('profile.edit');
        Route::post('profile', [ProfileController::class, 'update'])->name('profile.update');
    });
    Route::prefix('admin')->group(function () {
        Route::get('profile/edit-password', [ProfilePasswordController::class, 'edit'])->name('profile.password.edit');
        Route::post('profile/edit-password', [ProfilePasswordController::class, 'update'])->name('profile.password.update');
    });

    Route::prefix('admin')->group(function () {
        Route::get('cartas', [CartaController::class, 'index'])->name('cartas.index');
        Route::get('cartas/data', [CartaController::class, 'data'])->name('cartas.data');
        Route::post('cartas/store', [CartaController::class, 'store'])->name('cartas.store');
        Route::get('cartas/{carta}/edit', [CartaController::class, 'edit'])->name('cartas.edit');
        Route::delete('cartas/{carta}', [CartaController::class, 'destroy'])->name('cartas.destroy');
    });

    Route::prefix('admin')->group(function () {
        Route::get('/subcartas', [SubCartaController::class, 'index'])->name('subcartas.index');
        Route::post('/subcartas/datatables', [SubCartaController::class, 'datatables'])->name('subcartas.datatables');
        Route::post('/subcartas', [SubCartaController::class, 'store'])->name('subcartas.store');
        Route::put('/subcartas/{subcarta}', [SubCartaController::class, 'update'])->name('subcartas.update');
        Route::get('/subcartas/{id}', [SubCartaController::class, 'show'])->name('subcartas.show');
        Route::delete('/subcartas/{subCarta}', [SubCartaController::class, 'destroy'])->name('subcartas.destroy');
    });

    // Rutas para Alérgenos
    Route::prefix('admin/alergenos')->group(function () {
        Route::get('/', [AlergenoController::class, 'index'])->name('alergenos.index');
        Route::get('/datatables', [AlergenoController::class, 'datatables'])->name('alergenos.datatables'); // Cambiado a GET
        Route::post('/', [AlergenoController::class, 'store'])->name('alergenos.store');
        Route::get('/{alergeno}', [AlergenoController::class, 'show'])->name('alergenos.show');
        Route::put('/{alergeno}', [AlergenoController::class, 'update'])->name('alergenos.update');
        Route::delete('/{alergeno}', [AlergenoController::class, 'destroy'])->name('alergenos.destroy');
    });


    Route::get('/admin/cartas/{carta}/subcartas', [CartaController::class, 'getSubCartas']);
    Route::prefix('admin/platos')->name('platos.')->group(function () {
        Route::get('/', [PlatoController::class, 'index'])->name('index'); // vista principal con DataTable
        Route::get('/datatables', [PlatoController::class, 'datatables'])->name('datatables'); // JSON para DataTables
        Route::post('/store', [PlatoController::class, 'store'])->name('store'); // Crear/editar en el mismo modal
        Route::get('/{plato}/edit', [PlatoController::class, 'edit'])->name('edit'); // Cargar datos para editar vía AJAX
        Route::delete('/{plato}', [PlatoController::class, 'destroy'])->name('destroy'); // Eliminar
        Route::get('/{plato}', [PlatoController::class, 'show'])->name('show'); // Ver detalle
        Route::get('/carta/{carta}', [PlatoController::class, 'byCarta'])->name('byCarta'); // Obtener por carta
    });
    // Rutas para Bebidas
    Route::prefix('admin/bebidas')->name('bebidas.')->group(function () {
        Route::get('/', [BebidaController::class, 'index'])->name('index'); // vista principal con DataTable
        Route::get('/datatables', [BebidaController::class, 'datatables'])->name('datatables'); // JSON para DataTables
        Route::post('/store', [BebidaController::class, 'store'])->name('store'); // Crear/editar en el mismo modal
        Route::get('/{bebida}/edit', [BebidaController::class, 'edit'])->name('edit'); // Cargar datos para editar vía AJAX
        Route::delete('/{bebida}', [BebidaController::class, 'destroy'])->name('destroy'); // Eliminar
        Route::get('/{bebida}', [BebidaController::class, 'show'])->name('show'); // Ver detalle
        Route::get('/carta/{carta}', [BebidaController::class, 'byCarta'])->name('byCarta'); // Obtener por carta
    });

    //Ordenar registros SORT

    Route::prefix('admin')->group(function () {
        Route::get('/cartas/ordenar', [CartaController::class, 'ordenarVista'])->name('cartas.ordenar');
        Route::post('/cartas/ordenar', [CartaController::class, 'ordenarGuardar'])->name('cartas.ordenar.guardar');

        Route::get('/sub-cartas/ordenar', [SubCartaController::class, 'ordenarVista'])->name('subcartas.ordenar');
        Route::post('/sub-cartas/ordenar', [SubCartaController::class, 'ordenarGuardar'])->name('subcartas.ordenar.guardar');


        Route::get('/alergeno/ordenar', [AlergenoController::class, 'ordenarVista'])->name('alergenos.ordenar');
        Route::post('/alergeno/ordenar', [AlergenoController::class, 'ordenarGuardar'])->name('alergenos.ordenar.guardar');


        Route::get('/plato/ordenar', [PlatoController::class, 'ordenarVista'])->name('platos.ordenar');
        Route::post('/plato/ordenar', [PlatoController::class, 'ordenarGuardar'])->name('platos.ordenar.guardar');


        Route::get('/bebida/ordenar', [BebidaController::class, 'ordenarVista'])->name('bebidas.ordenar');
        Route::post('/bebida/ordenar', [BebidaController::class, 'ordenarGuardar'])->name('bebidas.ordenar.guardar');
    });
});


require __DIR__ . '/auth.php';
