@extends('adminlte::page')

@section('title', 'Ordenar Bebidas' . ' | ' . config('app.name'))

@section('content_header')
    <div class="w-100">
        @php
            $breadcrumbs = [
                ['name' => 'Inicio', 'route' => 'dashboard', 'icon' => 'fa-home'],
                ['name' => 'Bebidas', 'route' => 'bebidas.index'],
                ['name' => 'Ordenar Bebidas'],
            ];
        @endphp

        <nav aria-label="breadcrumb">
            <ol class="breadcrumb bg-light p-2 rounded shadow-sm">
                @foreach ($breadcrumbs as $breadcrumb)
                    @if (isset($breadcrumb['route']))
                        <li class="breadcrumb-item">
                            <a href="{{ route($breadcrumb['route']) }}">
                                @if (isset($breadcrumb['icon']))
                                    <i class="fas {{ $breadcrumb['icon'] }} mr-1"></i>
                                @endif
                                {{ $breadcrumb['name'] }}
                            </a>
                        </li>
                    @else
                        <li class="breadcrumb-item active" aria-current="page">{{ $breadcrumb['name'] }}</li>
                    @endif
                @endforeach
            </ol>
        </nav>
    </div>
@stop

@section('content')

    <div class="m-0">
        <div class="card shadow-sm">
            <div class="card-header">
                <div class="row align-items-center">
                    <!-- Título -->
                    <div class="col-12 col-md-6">
                        <h5 class="mb-md-0">Ordenar Bebidas</h5>
                    </div>

                    <!-- Botón -->

                </div>
            </div>

            <div class="card-body p-2">

                <p class="text-muted">Arrastra y suelta para cambiar el orden de las Bebidas.</p>

                @foreach ($cartas as $carta)
                    <div class="card mb-4 shadow-sm">
                        <div class="card-header bg-primary text-white">
                            <i class="fa-solid fa-layer-group"></i>
                            {{ $carta->translate(app()->getLocale())->nombre }}
                        </div>

                        {{-- Bebidas sin subcarta --}}
                        @if ($carta->bebidas->count())
                            <ul class="list-group list-group-flush sortable" data-carta-id="{{ $carta->id }}"
                                data-sub-id="null">
                                @foreach ($carta->bebidas as $bebida)
                                    <li class="list-group-item d-flex align-items-center" data-id="{{ $bebida->id }}">
                                        <i class="fa-solid fa-arrows-alt fa-lg me-3 text-secondary drag-handle"></i>
                                        {{ $bebida->translate(app()->getLocale())->nombre }}
                                        @if (!$bebida->activo)
                                            <span class="badge bg-danger ms-auto"><i class="fa-solid fa-ban"></i>
                                                Inactiva</span>
                                        @endif
                                    </li>
                                @endforeach
                            </ul>
                        @endif

                        {{-- Bebidas por subcarta --}}
                        @foreach ($carta->subCartas as $sub)
                            <div class="card-body border-top">
                                <h6 class="fw-bold">
                                    <i class="fa-solid fa-diagram-project"></i>
                                    {{ $sub->translate(app()->getLocale())->nombre }}
                                </h6>
                                <ul class="list-group list-group-flush sortable" data-carta-id="{{ $carta->id }}"
                                    data-sub-id="{{ $sub->id }}">
                                    @foreach ($sub->bebidas as $bebida)
                                        <li class="list-group-item d-flex align-items-center"
                                            data-id="{{ $bebida->id }}">
                                            <i class="fa-solid fa-arrows-alt fa-lg me-3 text-secondary drag-handle"></i>
                                            {{ $bebida->translate(app()->getLocale())->nombre }}
                                            @if (!$bebida->activo)
                                                <span class="badge bg-danger ms-auto"><i class="fa-solid fa-ban"></i>
                                                    Inactiva</span>
                                            @endif
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        @endforeach
                    </div>
                @endforeach

                <div class="mt-3">
                    <button id="guardarOrden" class="btn btn-success">
                        <i class="fa-solid fa-floppy-disk"></i> Guardar Orden
                    </button>
                </div>

            </div>
        </div>
    </div>





@stop

@section('css')
    <style>
        ul.sortable {
            list-style: none;
            padding-left: 0;
            margin: 0;
        }

        .sortable li {
            cursor: grab;
        }

        .sortable li:active {
            cursor: grabbing;
        }

        .ui-state-highlight {
            height: 2.5rem;
            background: #e9ecef;
            border: 2px dashed #adb5bd;
            border-radius: 0.5rem;
        }
    </style>
@stop

@push('js')
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>

    <script>
      

        $(function() {
            $(".sortable").sortable({
                placeholder: "ui-state-highlight",
                handle: ".drag-handle",
                cursor: "grabbing"
            }).disableSelection();

            $('#guardarOrden').click(function() {
                let orden = {};

                $(".sortable").each(function() {
                    let cartaId = $(this).data('carta-id');
                    let subId = $(this).data('sub-id');
                    let lista = [];

                    $(this).find('li').each(function() {
                        lista.push($(this).data('id'));
                    });

                    if (!orden[cartaId]) orden[cartaId] = {};
                    orden[cartaId][subId] = lista;
                });

                $.ajax({
                    url: "{{ route('bebidas.ordenar.guardar') }}",
                    method: "POST",
                    data: {
                        orden: orden,
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(resp) {
                        if (resp.success) {
                            Toast.fire({
                                icon: 'success',
                                title: 'Orden guardado correctamente'
                            });
                        }
                    },
                    error: function() {
                        Toast.fire({
                            icon: 'error',
                            title: 'Error al guardar el orden'
                        });
                    }
                });
            });
        });
    </script>
@endpush
