<div class="modal fade" id="bebidaModal" tabindex="-1" role="dialog" aria-labelledby="bebidaModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document"><!-- CAMBIADO A modal-lg -->
        <div class="modal-content">
            <div class="modal-header bg-secondary text-white">
                <h5 class="modal-title" id="bebidaModalLabel">Nuevo Bebida</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="bebidaForm" enctype="multipart/form-data">
                <div class="modal-body">
                    <input type="hidden" id="bebida_id" name="bebida_id">

                    <!-- === Carta y Subcarta === -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="carta_id">Carta *</label>
                                <select class="form-control" id="carta_id" name="carta_id" required>
                                    <option value="">Seleccione una carta</option>
                                    @foreach ($cartas as $carta)
                                        <option value="{{ $carta->id }}">
                                            {{ $carta->translate(app()->getLocale())->nombre ?? $carta->id }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="sub_carta_id">Subcarta</label>
                                <select class="form-control" id="sub_carta_id" name="sub_carta_id">
                                    <option value="">Seleccione una subcarta</option>
                                    @foreach ($subcartas as $subcarta)
                                        <option value="{{ $subcarta->id }}">
                                            {{ $subcarta->translate(app()->getLocale())->nombre ?? $subcarta->id }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <!-- Nombre -->
                        <div class="col-md-12">
                            <label>Nombre *</label>
                            @foreach ($langs as $lang)
                                <div class="input-group mb-2">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <img src="{{ asset($lang->image ?? 'images/empty.png') }}"
                                                alt="{{ $lang->name }}" width="20" height="20">
                                        </span>
                                    </div>
                                    <input type="text" class="form-control" id="nombre_{{ $lang->code }}"
                                        name="nombre[{{ $lang->code }}]" placeholder="Nombre en {{ $lang->name }}"
                                        required>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    


                    <!-- === Precios === -->
                    <div class="form-group">
                        <hr>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="precio_copa">Precio Copa</label>
                                    <input type="number" step="0.01" min="0"
                                        class="form-control precio-field" id="precio_copa" name="precio_copa">
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="precio_vaso">Precio Vaso</label>
                                    <input type="number" step="0.01" min="0"
                                        class="form-control precio-field" id="precio_vaso" name="precio_vaso">
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="precio_botella">Precio Botella</label>
                                    <input type="number" step="0.01" min="0"
                                        class="form-control precio-field" id="precio_botella" name="precio_botella">
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="precio_chupito">Precio Chupito</label>
                                    <input type="number" step="0.01" min="0"
                                        class="form-control precio-field" id="precio_chupito" name="precio_chupito">
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <!-- Descripción -->
                    <div class="form-group">
                        <label>Descripción</label>
                        @foreach ($langs as $lang)
                            <div class="input-group mb-2">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <img src="{{ asset($lang->image ?? 'images/empty.png') }}"
                                            alt="{{ $lang->name }}" width="20" height="20">
                                    </span>
                                </div>
                                <textarea class="form-control" id="descripcion_{{ $lang->code }}" name="descripcion[{{ $lang->code }}]"
                                    placeholder="Descripción en {{ $lang->name }}" rows="2"></textarea>
                            </div>
                        @endforeach
                    </div>
<!-- === Precio, Orden, Activo === -->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="activo" class="d-block">Estado</label>
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="activo" name="activo"
                                        value="1" checked>
                                    <label class="custom-control-label" for="activo">Activo</label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- === Imagen === -->
                    <div class="form-group">
                        <label for="imagen">Imagen del Bebida</label>
                        <input type="file" class="form-control-file" id="imagen" name="imagen"
                            accept="image/*">
                        <small class="form-text text-muted">Formatos: JPEG, PNG, GIF, WEBP. Máx: 2MB</small>
                        <div id="imagen-preview" class="mt-2"></div>
                        <div id="eliminar-imagen-container" class="mt-2" style="display: none;">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="eliminar_imagen"
                                    name="eliminar_imagen" value="1">
                                <label class="form-check-label" for="eliminar_imagen">Eliminar imagen actual</label>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- === Footer === -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>
