<?php

namespace Database\Seeders;

use App\Models\Lang;
use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(10)->create();

        User::updateOrCreate(
            ['email' => 'admin@admin.com'], // si ya existe, lo actualiza
            [
                'name' => 'Administrador',
                'email' => 'admin@admin.com',
                'password' => Hash::make('12345678'),
            ]
        );

        // Español (España) como default
        Lang::create([
            'code'    => 'es',
            'name'    => 'Español',
            'image'   => 'images/spain.png',
            'default' => true,
        ]);

        Lang::create([
            'code'    => 'en',
            'name'    => 'English',
            'image'   => 'images/usa.png',
            'default' => false,
        ]);

        Lang::create([
            'code'    => 'fr',
            'name'    => 'French',
            'image'   => 'images/france.png',
            'default' => false,
        ]);
    }
}
