<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Astrotomic\Translatable\Translatable;

class SubCarta extends Model
{
    use SoftDeletes, Translatable;

    protected $table = 'sub_cartas';

    protected $fillable = [
        'carta_id',
        'orden',
        'activo',
    ];

    // Campos que se traducen
    public $translatedAttributes = ['nombre', 'slug', 'descripcion'];

    // 👇 Muy importante: indicamos el modelo de traducción correcto
    public $translationModel = SubCartaLang::class;

    // 👇 También puedes forzar la tabla de traducciones
    public $translationForeignKey = 'sub_carta_id';

    public function carta()
    {
        return $this->belongsTo(Carta::class);
    }

    public function translations()
    {
        return $this->hasMany(SubCartaLang::class, 'sub_carta_id');
    }

        public function scopeActivo($query)
    {
        return $query->where('activo', true);
    }

    public function scopeOrdenado($query)
    {
        return $query->orderBy('orden', 'asc');
    }

    
    public function bebidas()
    {
        return $this->hasMany(Bebida::class);
    }



    public function platos()
    {
        return $this->hasMany(Plato::class);
    }
    
}
