<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Astrotomic\Translatable\Translatable;

class Bebida extends Model
{
    use SoftDeletes, Translatable;

    protected $table = 'bebidas';

    protected $fillable = [
        'carta_id',
        'sub_carta_id',
        'imagen',
        'orden',
        'activo'
    ];

    // Campos traducibles (sin slug aquí)
    public $translatedAttributes = ['nombre', 'descripcion'];

    // Clase de traducción personalizada
    public $translationModel = \App\Models\BebidaLang::class;
    public $translationForeignKey = 'bebida_id';

    /**
     * Relación con la carta
     */
    public function carta()
    {
        return $this->belongsTo(Carta::class);
    }

    /**
     * Relación con la subcarta
     */
    public function subCarta()
    {
        return $this->belongsTo(SubCarta::class);
    }

    /**
     * Relación con alergénicos (muchos a muchos)
     */
    public function alergenos()
    {
        return $this->belongsToMany(Alergeno::class, 'bebida_alergeno')
            ->withTimestamps();
    }

    /**
     * Scope para elementos activos
     */
    public function scopeActivo($query)
    {
        return $query->where('activo', true);
    }

    /**
     * Scope para ordenar por orden
     */
    public function scopeOrdenado($query)
    {
        return $query->orderBy('orden', 'asc');
    }

    /**
     * Accessor para el campo activo
     */
    public function getActivoAttribute($value)
    {
        return (bool) $value;
    }

    /**
     * Mutator para el campo activo
     */
    public function setActivoAttribute($value)
    {
        $this->attributes['activo'] = $value ? 1 : 0;
    }

    /**
     * Obtener los IDs de los alergénicos
     */
    public function getAlergenosIdsAttribute()
    {
        return $this->alergenos->pluck('id')->toArray();
    }
    public function precios()
    {
        return $this->hasMany(BebidaPrecio::class);
    }
}

 /* protected $table = 'bebidas';
    protected $fillable = [
        'carta_id',
        'sub_carta_id',
        'imagen',
        'orden',
        'activo'
    ];  */
